package w83b.w83bOperacionesPaso.w83bListados.w83bPreavisos;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


import w83b.w83bBeans.W83bListadosBean;

import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;

import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaEmpVariosPreExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListEmpVariosPre.xls";
		InputStream inputStream = W83bTablaEmpVariosPreExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaEmpVariosPre = (ArrayList)contexto.get("w83bResultadoListadosBean");
        W83bListadosBean listadoBean = (W83bListadosBean)contexto.get("w83bListadosBean");
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;
        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)4);
        
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)7);
        
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)4);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)7); 
        cell.setCellValue(tituloImagenEs.toString());
        
        
        row = sheet.getRow((short)10); // Creacin de la fila 1
        cell = row.getCell((short)0);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.empresaVariosPreavisos",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.empresaVariosPreavisos",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        //MAPEO FORMULARIO
        row = sheet.getRow((short)12);
        HSSFCell cell2;
        HSSFCell cell3;
        cell = row.getCell((short)3); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechentradaDesde",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechentradaDesde",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)5); 
        cell.setCellValue(listadoBean.getFechaEntradaDesde());
        cell = row.getCell((short)7); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechentradaHasta",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechentradaHasta",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)8); 
        cell2 = row.getCell((short)9); 
        cell3 = row.getCell((short)10);
        if(StringUtils.isNotEmpty(listadoBean.getFechaEntradaHasta())){
        	sheet.addMergedRegion(new Region((short)12,(short)8,(short)12,(short)9)); 
        	cell.setCellValue(listadoBean.getFechaEntradaHasta());
        }
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow((short)14);
        cell = row.getCell((short)0);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.cif",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.cif",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)1);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)2);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)3);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.fech_entrada",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.fech_entrada",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)4);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_preavisoabr",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_preavisoabr",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)5);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.fech_inicio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.fech_inicio",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
        
        cell = row.getCell((short)6);
        cell2 = row.getCell((short)7);
        cell3 = row.getCell((short)8);
        sheet.addMergedRegion(new Region((short)14,(short)6,(short)14,(short)8)); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.promotoresDesc",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.promotoresDesc",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
        
        cell = row.getCell((short)9);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.municipio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.municipio",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
        
        cell = row.getCell((short)10);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.prgl",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.prgl",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
        
        cell = row.getCell((short)11);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.observaciones",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.observaciones",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
        
        for(int i=0;i<listaEmpVariosPre.size();i++){
        	row = sheet.createRow((short)15+i); // Creacin de la fila 1
        	
        	//CIF
        	cell = row.createCell((short)0);
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaEmpVariosPre.get(i)).getCif())){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaEmpVariosPre.get(i)).getCif()));
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Cdigo centro trabajo
        	cell = row.createCell((short)1); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaEmpVariosPre.get(i)).getCodCentro())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bListadosBean)listaEmpVariosPre.get(i)).getCodCentro()));
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Razn
        	cell = row.createCell((short)2); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaEmpVariosPre.get(i)).getRazon())){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaEmpVariosPre.get(i)).getRazon()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	//Fecha entrada
        	cell = row.createCell((short)3); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaEmpVariosPre.get(i)).getFechaEntrada())){
        		cell.setCellValue(((W83bListadosBean)listaEmpVariosPre.get(i)).getFechaEntrada());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Nmero preaviso
        	cell = row.createCell((short)4); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaEmpVariosPre.get(i)).getNumPreaviso())){
        		cell.setCellValue(((W83bListadosBean)listaEmpVariosPre.get(i)).getNumPreaviso());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Fecha inicio
        	cell = row.createCell((short)5); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaEmpVariosPre.get(i)).getFechaInicio())){
        		cell.setCellValue(((W83bListadosBean)listaEmpVariosPre.get(i)).getFechaInicio());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Cdigos promotores
        	cell = row.createCell((short)6); 
        	cell2 = row.createCell((short)7);
        	cell3 = row.createCell((short)8);
            sheet.addMergedRegion(new Region((short)15+i,(short)6,(short)15+i,(short)8)); //NOPMD
            if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
            	if(StringUtils.isNotEmpty(((W83bListadosBean)listaEmpVariosPre.get(i)).getPromotores())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaEmpVariosPre.get(i)).getPromotores()));
            	}
            }
            else{
            	if(StringUtils.isNotEmpty(((W83bListadosBean)listaEmpVariosPre.get(i)).getPromotoreseu())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaEmpVariosPre.get(i)).getPromotoreseu()));
            	}
            }
            int tamanyoTexto = cell.getStringCellValue().length();
            if(43<tamanyoTexto){
               row.setHeightInPoints((short)(22*(tamanyoTexto/45)+1));
            }
        	
        	cell.setCellStyle(estiloFila(i,excel));
        	cell2.setCellStyle(estiloFila(i,excel));
        	cell3.setCellStyle(estiloFila(i,excel));
        	
        	//Municipio
        	cell = row.createCell((short)9); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaEmpVariosPre.get(i)).getMunicipio())){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaEmpVariosPre.get(i)).getMunicipio()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	//Preaviso global
        	cell = row.createCell((short)10); 
        	if(W83bClsConstantes.CONSTANTE_SI.equals(((W83bListadosBean)listaEmpVariosPre.get(i)).getPreavisoGlobal())){
            	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());        	
            }else if(W83bClsConstantes.CONSTANTE_NO.equals(((W83bListadosBean)listaEmpVariosPre.get(i)).getPreavisoGlobal())){
            	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());        	
            }else{
            	cell.setCellValue("");   
            }
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Observaciones
        	cell = row.createCell((short)11); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaEmpVariosPre.get(i)).getObservaciones())){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaEmpVariosPre.get(i)).getObservaciones()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoEmpVariosPre.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	

	private HSSFCellStyle estiloFilaCentro(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}

}
